% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Halle-Wittenberg.R
\docType{data}
\name{uni_halle}
\alias{uni_halle}
\title{Primary colors of the Martin Luther University Halle-Wittenberg, Germany}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on the 
\href{https://www.uni-halle.de}{MLU}'s 
\href{https://www.marketing.uni-halle.de/corporate-design/}{Corporate design} specifications (PDF).
}
\usage{
uni_halle
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_halle} provides the colors 
of the \href{https://example.org}{Martin Luther University Halle-Wittenberg} (MLU), Germany.
}
\details{
\code{uni_halle} contains 1 primary color \code{MLU gruen} 
and 7 faculty-specific colors.

\code{uni_halle} is based on the online/screen versions of HEX color definitions.
}
\examples{
uni_halle
unikn::seecol(uni_halle, main = "Colors of the MLU Halle-Wittenberg, Germany")  # view palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-10-05.
}
\concept{German university color palettes}
\keyword{datasets}
