% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Stuttgart.R
\docType{data}
\name{uni_stuttgart_print}
\alias{uni_stuttgart_print}
\title{Printing colors of the University of Stuttgart, Germany}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on the \href{https://www.uni-stuttgart.de/en}{Uni Stuttgart}'s
\href{https://www.beschaeftigte.uni-stuttgart.de/uni-services/oeffentlichkeitsarbeit/corporate-design/cd-dateien/Uni_Stuttgart_CD-Manual.pdf}{CD manual (PDF)}.
}
\usage{
uni_stuttgart_print
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_stuttgart_print} provides three primary colors, one secondary color and two alternative printing colors
of the \href{https://www.uni-stuttgart.de/en}{University of Stuttgart}, Germany.
}
\details{
The three primary colors are
\code{"white"},
\code{"anthrazit"} (defined as PANTONE 432U, CMYK 50/35/25/70, RGB 62/68/76, HEX #323232), and
\code{"mittelblau"} (defined as PANTONE 293U, CMYK 100/70/0/0, RGB 0/81/158, HEX #004191).

The secondary color is
\code{"hellblau"} (defined as PANTONE 2985U, CMYK 70/0/0/0, RGB 0/190/255, HEX #00BEFF)
and used for color accents.

The alternative printing colors are provided to replace \code{"anthrazit"} for better contrast. Use
\code{"anthrazit dark"} (defined as CMYK 0/0/0/90) when printing black and white, and
\code{"black"} (defined as CMYK 0/0/0/100) when printing text block in correspondence.

\code{uni_stuttgart_print} uses the HEX color definitions.
CMYK color differs from RGB and HEX definition.
For \code{"anthrazit"} and \code{"mittelblau"} the RGB and HEX definitions also differ numerically,
yet are visually indistinguishable. Our color palette is based on the HEX definition.
}
\examples{
uni_stuttgart_print
unikn::seecol(uni_stuttgart_print, col_bg = "grey90", 
              main = "Printing colors of the University of Stuttgart")  # view palette

}
\seealso{
\code{\link{uni_stuttgart_1}} for Stuttgart's primary colors without printing colors;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-05-31.
}
\concept{German university color palettes}
\keyword{datasets}
