% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifed.R
\name{unifed}
\alias{unifed}
\alias{quasiunifed}
\alias{unifed.canonical.link}
\title{Family object for the unifed distribution}
\usage{
unifed(link = "logit", ...)

quasiunifed(link = "logit", ...)

unifed.canonical.link()
}
\arguments{
\item{link}{a specification for the model link function.  This can
be a name/expression, a literal character string, a length-one
character vector or an object of class ‘"link-glm"’ (such as
generated by ‘make.link’) provided it is not specified via one
of the accepted names. The \code{unifed} family accepts the
links (as names) 'canonical', 'logit', 'probit', 'cloglog' and
'cauchit'.}

\item{...}{Optional \code{tol} and \code{maxit} arguments for
\code{\link{unifed.unit.deviance}}.}
}
\value{
\code{unifed} returns a family object for using the unifed
    distribution with the \code{glm} function.

The \code{quasiunifed} family differs from the
    \code{unifed} only in that the dispersion parameter is not
    fixed to one.

An object of class \code{"link-glm"}.
}
\description{
Family object for the unifed distribution
}
\details{
The link 'canonical' is not part of the standard names accepted by
 \code{make.link()} from the stats package. It corresponds to the
 canonical link function for the unifed distribution, which is the
 inverse of the derivative of its cumulant generator. There is no
 explicit formula for it. The function
 \code{\link{unifed.kappa.prime.inverse}()} implements it using the
 Newthon-Raphson method.

This function is used inside of \code{unifed()} when the link
parameter is set to \code{"canonical"}. It returns the link
function, inverse link function, the derivative dmu/deta and a
function for domain checking for the unifed distribution canonical
link.
}
\references{
{

Jørgensen, Bent (1992). The Theory of Exponential Dispersion Models and Analysis  of  Deviance.
Instituto de Matemática Pura e Aplicada, (IMPA), Brazil.

}

{

Wedderburn, R. W. M. (1974). Quasi-likelihood functions, generalized linear models, and the Gauss—Newton method. Biometrika. \bold{61} (3): 439–447.

McCullagh, Peter; Nelder, John (1989). Generalized Linear Models (second ed.). London: Chapman and Hall.

}
}
\seealso{
\code{Gamma} \code{\link{unifed.kappa.prime.inverse}}

\code{make.link}
}
