#' @keywords internal
pca <- function(scores, M, SD, b, corm) {
  scores_weighted = b * scores
  M_weighted = b * M
  SD_weighted = b * SD
  standardized_weighted = (scores_weighted - M_weighted) / SD_weighted
  pca_result = eigen(corm)
  pc1_vector = pca_result$vectors[, 1]
  pc1_sum = sum(standardized_weighted * pc1_vector)
  if (sum(scores) > sum(M)) {
    pc1_sum = abs(pc1_sum)
  }
  return(pc1_sum)
}
