% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mllgser.R
\name{mllgser}
\alias{mllgser}
\title{Logarithmic series distribution maximum likelihood estimation}
\usage{
mllgser(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{Not in use.}
}
\value{
\code{mllgser} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{theta}.
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
For the density function of the Logarithmic series distribution see
\link[extraDistr:LogSeries]{Logarithmic series}. For an example data set, see \link{corbet}.
}
\examples{
theta_hat <- mllgser(corbet)

# The corbert data contains observations from 1 to 24.
observed <- table(corbet)

# The chi square test evaluated at the maximum likelihood is highly significant.
expected <- extraDistr::dlgser(1:24, theta_hat)
chisq.test(observed, p = expected / sum(expected))

# But chi square test evaluated at 0.997 (used in Corbet) is not.
expected <- extraDistr::dlgser(1:24, 0.997)
chisq.test(observed, p = expected / sum(expected))

# The chi square for `dzipf` is similar.
expected <- sads::dzipf(1:24, mlzipf(corbet)[1], mlzipf(corbet)[2]) * length(corbet)
chisq.test(observed, p = expected / sum(expected))
}
\references{
Fisher, R. A., Corbet, A. S., & Williams, C. B. (1943). The relation between the number of species and the number of individuals in a random sample of an animal population. The Journal of Animal Ecology, 12(1), 42. https://doi.org/10.2307/1411

Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.
}
\seealso{
\link[extraDistr:LogSeries]{Logarithmic series} for the density.
}
