% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direction.R
\name{direction}
\alias{direction}
\title{Directions from data cells to headers}
\description{
How to use functions with a \code{direction} parameter.

Data cells relate to header cells by their proximity in a given direction.
The point of view is always \emph{from} the data cell \emph{to} the header.  For
example, the direction \code{"up"} means "from each data cell go directly up to a
cell at the edge of the table, which is the header cell."

Scroll down to the "Tables" section for a visual explanation.

Legacy directions \code{"N"}, \verb{"NNW", }"W"\verb{, }"WNW"`, etc. are still supported.
Scroll down to the "Legacy directions" section for how they map to the new
directions.
\itemize{
\item \code{"up"} means from each data cell go directly up to a cell at the edge of
the the table, which is the header cell.
\item \code{"up-left"} means from each data cell go directly up to a cell at the edge
of the the table, then if the cell is blank go left until a cell that has a
value, which is the header cell.
\item \code{"up-right"} means from each data cell go directly up to a cell at the edge
of the the table, then if the cell is blank go right until a cell that has a
value, which is the header cell.
\item \code{"left"} means from each data cell go directly left to a cell at the edge
of the the table, which is the header cell.
\item \code{"left-up"} means from each data cell go directly left to a cell at the
edge of the the table, then if the cell is blank go up until a cell that has
a value, which is the header cell.
\item \code{"left-down"} means from each data cell go directly left to a cell at the
edge of the the table, then if the cell is blank go down until a cell that
has a value, which is the header cell.
\item \code{"right"} means from each data cell go directly right to a cell at the edge
of the the table, which is the header cell.
\item \code{"right-up"} means from each data cell go directly right to a cell at the
edge of the the table, then if the cell is blank go up until a cell that has
a value, which is the header cell.
\item \code{"right-down"} means from each data cell go directly right to a cell at the
edge of the the table, then if the cell is blank go down until a cell that
has a value, which is the header cell.
\item \code{"down"} means from each data cell go directly down to a cell at the edge
of the the table, which is the header cell.
\item \code{"down-left"} means from each data cell go directly down to a cell at the
edge of the the table, then if the cell is blank go left until a cell that
has a value, which is the header cell.
\item \code{"down-right"} means from each data cell go directly down to a cell at the
edge of the the table, then if the cell is blank go right until a cell that
has a value, which is the header cell.
}
}
\section{-ish}{


The difference between \code{"up"} and \code{"up-ish"} (and similar pairs of directions)
is that \code{"up"} finds headers directly above the data cell, whereas \code{"up-ish"}
matches the nearest header, whether above-left, above-right or directly above
the data cell.  This is useful for matching headers that are not aligned to
the edge of the data cells that they refer to.  There can be a tie in the
directions \code{"up-ish"}, \code{"down-ish"}, \code{"left-ish"} and \code{"right-ish"} , causing
\code{NA}s to be returned in the place of header values.  Avoid ties by using
\code{\link[=justify]{justify()}} first to align header cells to the corner of the data cells they
describe.
\itemize{
\item \code{"up-ish"} means the closest cell at the top edge of the table without
crossing a border defined by the \code{border} parameter.
\item \code{"left-ish"} means the closest cell at the left-hand edge of the table
without crossing a border defined by the \code{border} parameter.
\item \code{"right-ish"} means the closest cell at the right-hand edge of the table
without crossing a border defined by the \code{border} parameter.
\item \code{"down-ish"} means the closest cell at the bottom edge of the table without
crossing a border defined by the \code{border} parameter.
}
}

\section{Tables}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{+----------------+-------------+-------------+
|                | up-left     | up-left     |
+                +-------------+-------------+
|                | up   | up   | up   | up   |
+----------------+------+------+------+------+
| left-up | left | data | data | data | data |
+         +------+------+------+------+------+
|         | left | data | data | data | data |
+---------+------+------+------+------+------+
| left-up | left | data | data | data | data |
+         +------+------+------+------+------+
|         | left | data | data | data | data |
+---------+------+------+------+------+------+
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{+-------------+-------------+------------------+
| up-right    | up-right    |                  |
+-------------+-------------+                  +
| up   | up   | up   | up   |                  |
+------+------+------+------+------------------+
| data | data | data | data | right | right-up |
+------+------+------+------+-------+          +
| data | data | data | data | right |          |
+------+------+------+------+-------+----------+
| data | data | data | data | right | right-up |
+------+------+------+------+-------+          +
| data | data | data | data | right |          |
+------+------+------+------+-------+----------+
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{+-----------+------+------+------+------+------+
|           | left | data | data | data | data |
+           +------+------+------+------+------+
| left-down | left | data | data | data | data |
+-----------+------+------+------+------+------+
|           | left | data | data | data | data |
+           +------+------+------+------+------+
| left-down | left | data | data | data | data |
+-----------+------+------+------+------+------+
|                  | down | down | down | down |
+                  +------+------+------+------+
|                  | down-left   | down-left   |
+-----------+------+-------------+-------------+
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{'+------+------+------+------+-------+------------+
| data | data | data | data | right |            |
+------+------+------+------+-------+            +
| data | data | data | data | right | right-down |
+------+------+------+------+-------+------------+
| data | data | data | data | right |            |
+------+------+------+------+-------+            +
| data | data | data | data | right | right-down |
+------+------+------+------+-------+------------+
| down | down | down | down |                    |
+------+------+------+------+                    +
|  down-right |  down-right |                    |
+-------------+-------------+--------------------+
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{+-----------------+----------------------+-----------------------------+
|                 |        up-ish        |               up-ish        |
+                 +----------------------+-----------------------------+
|                 | up   | up     | up   | up   | up   | up     | up   |
+-----------------+------+--------+------+------+------+--------+------+
|          | left | data | data   | data | data | data | data   | data |
+          +------+------+--------+------+------+------+--------+------+
| left-ish | left | data | data   | data | data | data | data   | data |
+          +------+------+--------+------+------+------+--------+------+
|          | left | data | data   | data | data | data | data   | data |
+----------+------+------+--------+------+------+------+--------+------+
|          | left | data | data   | data | data | data | data   | data |
+          +------+------+--------+------+------+------+--------+------+
|          | left | data | data   | data | data | data | data   | data |
+          +------+------+--------+------+------+------+--------+------+
| left-ish | left | data | data   | data | data | data | data   | data |
+          +------+------+--------+------+------+------+--------+------+
|          | left | data | data   | data | data | data | data   | data |
+----------+------+------+--------+------+------+------+-----  -+------+
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{+------+----------+------+------+------+----------+------+-------+-----------+
| data | data     | data | data | data | data     | data | right |           |
+------+----------+------+------+------+----------+------+-------+           +
| data | data     | data | data | data | data     | data | right | right-ish |
+------+----------+------+------+------+----------+------+-------+           +
| data | data     | data | data | data | data     | data | right |           |
+------+----------+------+------+------+----------+------+-------+-----------+
| data | data     | data | data | data | data     | data | right |           |
+------+----------+------+------+------+----------+------+-------+           +
| data | data     | data | data | data | data     | data | right |           |
+------+----------+------+------+------+----------+------+-------+           +
| data | data     | data | data | data | data     | data | right | right-ish |
+------+----------+------+------+------+----------+------+-------+           +
| data | data     | data | data | data | data     | data | right |           |
+------+----------+------+------+------+----------+------+-------+-----------+
| down | down     | down | down | down | down     | down |                   |
+------+----------+------+------+------+----------+------+                   +
|        down-ish        |               down-ish        |                   |
+------------------------+-------------------------------+-------------------+
}\if{html}{\out{</div>}}
}

\section{Legacy directions}{


Older versions of unpivotr used different names for the directions, based on
the points of the compass.  These are still supported but are discouraged.

\if{html}{\out{<div class="sourceCode">}}\preformatted{| old direction | new direction |
|---------------|---------------|
| N             | up            |
| NNW           | up-left       |
| NNE           | up-right      |
| W             | left          |
| WNW           | left-up       |
| WSW           | left-down     |
| E             | right         |
| ENE           | right-up      |
| ESE           | right-down    |
| S             | down          |
| SSW           | down-left     |
| SSE           | down-right    |
}\if{html}{\out{</div>}}
}

