% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.test1.R
\name{um.test1}
\alias{um.test1}
\title{Test of Mediation Effects Within One Single Object}
\usage{
um.test1 (obj, scale = "RD",type = c("PNDE", "TNIE"), Cf_lv=0.95, verbose=TRUE)
}
\arguments{
\item{obj}{a resulting object of class \code{"unvs.med"}
from function \code{\link{FormalEstmed}}.}

\item{scale}{a character variable of the effect scales. It can be \code{"RD"}, \code{"OR"} or \code{"RR"}.
The default is \code{"RD"}.}

\item{type}{a character variable of the effect types, containing more than two.
The default is \code{c("PNDE", "TNIE")}.}

\item{Cf_lv}{a numeric variable of the confident interval.
The default is 0.95.}

\item{verbose}{a logical value indicating whether the output is display. The default is TRUE.
This is a standard parameter required by CRAN.}
}
\value{
No return value, called for displaying the output of the test result.
}
\description{
This function tests the difference of various types of effects within
one single estimation object from function \code{\link{FormalEstmed}}. It
is used to compare whether an effect is distinct from another.
}
\examples{
\donttest{
# Running formal estimation
data(testdata)
med_model=glm(med~exp+C1+C2+C3, data=testdata, family=binomial) # Fitting mediator's model
out_model=lm(out~med*exp+C1+C2+C3, data=testdata) # Fitting outcome's model
r1 = FormalEstmed (med_model=med_model, out_model=out_model,
data=testdata, exposure = "exp") # Running formal estimation

# Test examples
um.test1(r1) # Test of the default settings (PNDE v.s. TNIE on RD scales).
um.test1(r1,"OR") # Test of PNDE v.s. TNIE on OR scales.
# Test of PNDE v.s. TNIE on RD and OR scales:
um.test1(r1,c("RD", "OR"))
# Test of PNDE v.s. TNIE v.s. TE on RD and OR scales:
um.test1(r1,c("RD", "OR"), c("PNDE", "TNIE", "TE"))
# Test of PNDE v.s. TNIE v.s. TE on RD, OR and RR scales:
um.test1(r1, scale=c("RD", "OR", "RR"), type=c("PNDE", "TNIE", "TE"))
}
}
