% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_subset}
\alias{dist_subset}
\title{Extract parts of a \code{dist} object.}
\usage{
dist_subset(d, idx)
}
\arguments{
\item{d}{A distance matrix object of class \code{dist}.}

\item{idx}{Indices specifying the subset of distances to extract.}
}
\value{
A distance matrix.
}
\description{
Extract a subset of values from a distance matrix. This function also works
to re-arrange the rows of a distance matrix, if they are provided in the
desired order.
}
\examples{
m4 <- matrix(1:16, nrow=4, dimnames=list(LETTERS[1:4]))
dm4 <- dist(m4)
dist_subset(dm4, c("A", "B", "C"))
dist_subset(dm4, c("D", "C", "B", "A"))
}
