% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modular_vacalib.R
\name{modular.vacalib}
\alias{modular.vacalib}
\title{Modular VA-Calibration}
\usage{
modular.vacalib(
  va_unlabeled = NULL,
  age_group = NULL,
  calibmodel.type = c("Mmatprior", "Mmatfixed")[1],
  Mmat.asDirich = NULL,
  Mmat.fixed = NULL,
  donotcalib = NULL,
  donot.calib_type = c("learn", "fixed")[1],
  nocalib.threshold = 0.1,
  stable = TRUE,
  ensemble = NULL,
  pss = NULL,
  nMCMC = 5000,
  nBurn = 5000,
  nThin = 1,
  adapt_delta_stan = 0.9,
  refresh.stan = NULL,
  seed = 1,
  verbose = TRUE,
  saveoutput = FALSE,
  output_filename = NULL,
  plot_it = TRUE
)
}
\arguments{
\item{va_unlabeled}{A named list. Algorithm-specific unlabeled VA-only data.

For example, \code{list("algo1" = algo1_output, "algo2" = algo2_output, ...)}

Algorithm names (\code{"algo1"}, \code{"algo2"}, ...) can be "eava", "insilicova", or "interva".

Data (\code{algo1_output}, \code{algo2_output}, ...) can be broad causes (output from the \code{cause_map()} function in this package), or broad-cause-specific death counts (integer vector).

Can be different for different algorithms.

Total number of deaths for different algorithms can be different.}

\item{age_group}{Character. Age-group of interest.

\code{"neonate"} or \code{"child"}.

\code{"neonate"} ages between 0-27 days, or \code{"child"} ages between 1-59 months.}

\item{calibmodel.type}{Character. How to utilize misclassification estimates.

\code{"Mmatprior"} (default). Propagates uncertainty in the misclassification matrix estimates.

\code{"Mmatfixed"}. Uses fixed (default: posterior mean) misclassification matrix estimates.}

\item{Mmat.asDirich}{A named list. Similarly structured as \code{va_data}.

Needed only if \code{calibmodel.type = "Mmatprior"} (propagates uncertainty).

For example, \code{list("algo1" = Mmat.asDirich_algo1, "algo2" = Mmat.asDirich_algo2, ...)}.

List of algorithm-specific Dirichlet prior on misclassification matrix to be used for calibration.

Names and length must be identical to \code{va_data}.

If algorithm names (\code{"algo1"}, \code{"algo2"}, ...) are \code{"eava"}, \code{"insilicova"} or \code{"interva"}, and \code{Mmat.asDirich} is missing, it by default uses the CHAMPS-based estimates (Dirichlet approximation of posterior) stored in \code{Mmat_champs} in this package.

See \code{Mmat_champs} for details.

If \code{Mmat.asDirich} is not missing, whatever provided is used.

If any algorithm name (\code{"algo1"}, \code{"algo2"}, ...) is different from \code{"eava"}, \code{"insilicova"} or \code{"interva"}, \code{Mmat.asDirich} must be provided.

\code{Mmat.asDirich_algo1} is a matrix of dimension CHAMPS ("gold standard") cause by VA cause.

\code{Dirichlet(Mmat.asDirich_algo1[i,])} is used as informative prior on classification rates for CHAMPS cause \code{i}.}

\item{Mmat.fixed}{A named list. Similarly structured as \code{va_data} or \code{Mmat.asDirich}.

Needed only if \code{calibmodel.type = "Mmatfixed"} (no uncertainty propagation).

For example, \code{list("algo1" = Mmat.fixed_algo1, "algo2" = Mmat.fixed_algo2, ...)}

List of algorithm-specific fixed misclassification matrix to be used for calibration.

Names and length must be identical to \code{va_data}.

If algorithm names (\code{"algo1"}, \code{"algo2"}, ...) are \code{"eava"}, \code{"insilicova"}, or \code{"interva"} and \code{Mmat.fixed} is missing, it by default uses the CHAMPS-based estimates (posterior mean) stored in \code{Mmat_champs} in this package.

See \code{Mmat_champs} for details.

If \code{Mmat.fixed} is not missing, whatever provided is used.

If any algorithm name (\code{"algo1"}, \code{"algo2"}, ...) is different from \code{"eava"}, \code{"insilicova"} or \code{"interva"}, \code{Mmat.fixed} must be provided. \code{Mmat.fixed_algo1} is a matrix of dimension CHAMPS cause X VA cause. \code{Mmat.fixed_algo1[i,]} are the classification rates for CHAMPS cause \code{i}.}

\item{donotcalib}{A named list. Similarly structured as \code{va_data}, \code{Mmat.asDirich}, or \code{Mmat.fixed}.

List of broad causes for each CCVA algorithm that we do not want to calibrate

Default: \code{list("eava"="other", "insilicova"="other", "interva"="other")}. That is, \code{"other"} cause is not calibrated.

For neonates, the broad causes are \code{"congenital_malformation"}, \code{"pneumonia"}, \code{"sepsis_meningitis_inf"}, \code{"ipre"}, \code{"other"}, or \code{"prematurity"}.

For children, the broad causes are \code{"malaria"}, \code{"pneumonia"}, \code{"diarrhea"}, \code{"severe_malnutrition"}, \code{"hiv"}, \code{"injury"}, \code{"other"}, \code{"other_infections"}, \code{"nn_causes"} (neonatal causes).

Set \code{list("eava" = NULL, "insilicova" = NULL, "interva" = NULL)} if you want to calibrate all causes.}

\item{donot.calib_type}{Character. \code{"fixed"} or \code{"learn"} (default).

For \code{"fixed"}, only broad causes that are provided in \code{"donotcalib"} are not calibrated.

For \code{"learn"}, it learns from \code{"Mmat.fixed"} or \code{"Mmat.asDirich"} if any other causes cannot be calibrated.

For \code{"learn"}, it identifies VA causes for which the misclassification rates do not vary across CHAMPS causes.

In that case, the calibration equation becomes ill-conditioned (see the footnote below Section 3.8 in Pramanik et al. (2025)). Currently, we address this by not calibrating VA causes for which the misclassification rates are similar along the rows (CHAMPS causes). VA causes (Columns) for which the rates along the rows (CHAMPS causes) do not vary more that \code{"nocalib.threshold"} are not calibrated. \code{"donotcalib"} is accordingly updated for each CCVA algorithm.}

\item{nocalib.threshold}{Numeric between 0 and 1. The value used for screening VA causes that cannot be calibrated when \code{donot.calib_type = "learn"}. Default: 0.1.}

\item{stable}{Logical. \code{TRUE} (default) or \code{FALSE}. Setting \code{TRUE} improves stability in calibration.}

\item{ensemble}{Logical. \code{TRUE} (default) or \code{FALSE}.

Whether to perform ensemble calibration when outputs from multiple algorithms are provided.}

\item{pss}{Positive numeric. Degree of shrinkage of calibrated cause-specific mortality fraction (CSMF) estimate towards uncalibrated estimates.

Always 0 when \code{stable=TRUE}. Defaults to 4 when \code{stable=FALSE}.}

\item{nMCMC}{Positive integer. Total number of posterior samples to perform inference on.

Total number of iterations are \code{nBurn + nMCMC*nThin}.

Default 5000.}

\item{nBurn}{Positive integer. Total burn-in in posterior sampling.

Total number of iterations are \code{nBurn + nMCMC*nThin}.

Default 5000.}

\item{nThin}{Positive integer. Number of thinning in posterior sampling.

Total number of iterations are \code{nBurn + nMCMC*nThin}.

Default 1.}

\item{adapt_delta_stan}{Positive numeric between 0 and 1. \code{"adapt_delta"} parameter in \code{rstan}.

Influences the behavior of the No-U-Turn Sampler (NUTS), the primary MCMC sampling algorithm in Stan.

Default 0.9.}

\item{refresh.stan}{Positive integer. Report progress at every \code{refresh.stan}-th iteration.

Default \code{(nBurn + nMCMC*nThin)/10}, that is at every 10\% progress.}

\item{seed}{Numeric. \code{"seed"} parameter in rstan.

Default 1.}

\item{verbose}{Logical. Reports progress or not.

\code{TRUE} (default) or \code{FALSE}.}

\item{saveoutput}{Logical. Save output or not.

\code{TRUE} (default) or \code{FALSE}.}

\item{output_filename}{Character. Output name to save as.

Default \code{paste0("calibratedva_", calibmodel.type)}. That is \code{"calibratedva_Mmatprior"} or \code{"calibratedva_Mmatfixed"}.}

\item{plot_it}{Logical. Whether to return comparison plot for summary.

\code{TRUE} (default) or \code{FALSE}.}
}
\value{
A named list. Use \code{vacalibration()} for general purpose.
}
\description{
Modular VA-Calibration
}
