% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{as_table}
\alias{as_table}
\title{Create table of estimates}
\usage{
as_table(..., which = "CR", labels = NA)
}
\arguments{
\item{...}{One or more objects of class \code{"vaccine_est"} returned by
\code{\link{est_ce}}.}

\item{which}{One of c("CR", "CVE"); controls whether the table contains CR or
CVE values.}

\item{labels}{A character vector of length equal to length(list(...))
representing curve labels}
}
\value{
A table of CR or CVE values
}
\description{
Format estimates returned by \code{\link{est_ce}} as a table
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_cox <- est_ce(dat=dat, type="Cox", t_0=578)
ests_np <- est_ce(dat=dat, type="NP", t_0=578)
ests_table <- as_table(ests_cox, ests_np)
head(ests_table)
}
}
