% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_boundary.R
\name{detect_boundary_num}
\alias{detect_boundary_num}
\title{Detect the allowed range for numerical variables}
\usage{
detect_boundary_num(x, eps = 1e-08, ...)
}
\arguments{
\item{x}{\code{\link[validate:validator]{validate::validator()}} object, rule set to be checked}

\item{eps}{detected fixed values will have this precision.}

\item{...}{currently not used}
}
\value{
\code{\link[=data.frame]{data.frame()}} with columns "variable", "lowerbound", "upperbound".
}
\description{
Detect for each numerical variable in a validation rule set, what its maximum and minimum allowed values are.
The rule set may constrain numerical variables to a subset of their values.
This allows for manual rule set checking: does rule set \code{x} overly constrain numerical values?
}
\details{
This procedure only finds minimum and maximum values, but misses gaps.
}
\examples{
rules <- validator(
  x >= 1,
  x + y <= 10,
  y >= 6
)

detect_boundary_num(rules)

rules <- validator(
  job \%in\% c("yes", "no"),
  if (job == "no") income == 0,
  income > 0
)

detect_boundary_cat(rules)
}
\references{
Statistical Data Cleaning with R (2017), Chapter 8, M. van der Loo, E. de Jonge

Simplifying constraints in data editing (2015). Technical Report 2015|18, Statistics Netherlands, J. Daalmans
}
\seealso{
\code{\link[=detect_fixed_variables]{detect_fixed_variables()}}

Other feasibility: 
\code{\link{detect_boundary_cat}()},
\code{\link{detect_contradicting_if_rules}()},
\code{\link{detect_infeasible_rules}()},
\code{\link{is_contradicted_by}()},
\code{\link{is_infeasible}()},
\code{\link{make_feasible}()}
}
\concept{feasibility}
