% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{compute_oos_degradation}
\alias{compute_oos_degradation}
\title{Compute OOS Degradation}
\usage{
compute_oos_degradation(insample_metrics, cv_results)
}
\arguments{
\item{insample_metrics}{Named list with in-sample metrics.}

\item{cv_results}{Data frame from rolling_window_cv.}
}
\value{
Data frame with degradation percentages.
}
\description{
Compares out-of-sample metrics to in-sample metrics.
}
\examples{
insample <- list(rmse_fe = 0.05, rmse_m = 0.04)
cv_res <- data.frame(
  rmse_fe_all = c(0.06, 0.055, 0.058),
  rmse_m_all = c(0.045, 0.042, 0.044)
)
degradation <- compute_oos_degradation(insample, cv_res)
print(degradation)

}
