% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ve.R
\name{glmParametricSampling}
\alias{glmParametricSampling}
\title{Accounting for the uncertainty on the fitted \code{"glm"} model and observed data}
\usage{
glmParametricSampling(Fit, nboot = 2000, Data.vaccinated, Data.control)
}
\arguments{
\item{Fit}{an object of class inheriting from \code{"glm"} representing the fitted model}

\item{nboot}{a numeric value for number of bootstrap samples for confidence interval construction}

\item{Data.vaccinated}{a data frame for the vaccinated group, containing the variables in the fitted model; data must include a column called "vaccine" with binary indicator of vaccination status}

\item{Data.control}{a data frame for the control group, containing the variables in the fitted model; data must include a column called "vaccine" with binary indicator of vaccination status}
}
\value{
a vector of vaccine efficacy values \code{VE_set}, with length of \code{nboot}
}
\description{
\code{glmParametricSampling} is used for vaccine efficacy confidence interval construction. 
It provides a vector of vaccine efficacy values, with length of \code{nboot}. 95\% confidence interval, defined by 2.5th and 97.5th percentile of this vector,
accounts for the uncertainty on the model fit (via parametric resampling of the posterior distribution of the model parameters) and observed data (via bootstrapping).
}
\examples{
# Load required packages
library(dplyr)

# Load an example dataset
data(data_temp)
Data.vaccinated <- filter(data_temp, vaccine == 1)
Data.control <- filter(data_temp, vaccine == 0)

# Fit logistic model relating neutralizing titer to disease status
logisticFit <- glm(disease_any ~ nAb1, data = data_temp, family = binomial())

# Estimate 95\\% confidence interval of vaccine efficacy based on the fitted model
efficacySet <- glmParametricSampling(logisticFit, nboot = 500, Data.vaccinated, Data.control)
CI <- lapply(EfficacyCI(efficacySet),"*", 100)

}
