% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_bracket_comparisons}
\alias{add_bracket_comparisons}
\title{Create comparison specification for vbracket}
\usage{
add_bracket_comparisons(..., groups1 = NULL, groups2 = NULL, labels = NULL)
}
\arguments{
\item{...}{Named arguments or list of comparisons. Each comparison can be:
\itemize{
  \item A character vector of length 3: c(group1, group2, label)
  \item A named list: list(from = "A", to = "B", label = "***")
}}

\item{groups1}{Character vector of first groups to compare.}

\item{groups2}{Character vector of second groups to compare.}

\item{labels}{Character vector of significance labels.}
}
\value{
A data frame with columns: group1, group2, label
}
\description{
Helper function to create a properly formatted comparison data frame
for use with guide_legend_bracket().
}
\examples{
# Using individual vectors
add_bracket_comparisons(
  groups1 = c("A", "C"),
  groups2 = c("B", "D"),
  labels = c("***", "ns")
)

# Using ... with vectors
add_bracket_comparisons(
  c("A", "B", "***"),
  c("C", "D", "ns")
)
}
