% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{v_scale_size}
\alias{v_scale_size}
\title{Size scale for continuous data}
\usage{
v_scale_size(
  vc,
  name = NULL,
  range = c(5, 30),
  ...,
  position = c("right", "bottom", "left", "top"),
  align = c("middle", "start", "end")
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}} or specific chart's type function.}

\item{name}{Title for the legend.}

\item{range}{Range of sizes for the points plotted.}

\item{...}{Additional parameters for the legend.}

\item{position}{Position of the legend.}

\item{align}{Alignment of the legend.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Size scale for continuous data
}
\examples{
library(vchartr)
data("penguins", package = "palmerpenguins")

vchart(penguins) \%>\%
  v_scatter(aes(
    x = bill_length_mm, 
    y = bill_depth_mm,
    size = body_mass_g
  )) \%>\% 
  v_scale_size(
    name = "Body mass",
    range = c(1, 20)
  )
}
