% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_progress}
\alias{v_progress}
\title{Create a Progress Chart}
\usage{
v_progress(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Progress Chart
}
\examples{

library(vchartr)

vchart() \%>\%
  v_progress(aes(0.85, "My progress"))

data.frame(
  x = c(0.4, 0.3, 0.8, 0.6),
  y = paste("Course", 1:4)
) \%>\%
  vchart() \%>\%
  v_progress(
    aes(x, y),
    cornerRadius = 20,
    bandWidth = 30
  ) \%>\%
  v_scale_y_discrete(
    label = list(visible = TRUE),
    domainLine = list(visible = FALSE)
  )
}
