% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.agree}
\alias{replicate.agree}
\title{Compares and combines G-index of agreement in original and follow-up studies}
\usage{
replicate.agree(alpha, f1, n1, f2, n2, k)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of objects rated in agreement in original study}

\item{n1}{sample size (number of objects) in original study}

\item{f2}{number of objects rated in agreement in follow-up study}

\item{n2}{sample size (number of objects) in follow-up study}

\item{k}{number of rating categories}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in G-indicies
\item Row 4 estimates the average G-index
}

The columns are:
\itemize{
\item Estimate - MLE of G-index (single study, difference, average)
\item SE - standard error of adjusted estimate
\item LL - lower limit of the adjusted confidence interval
\item UL - upper limit of the adjusted confidence interval
}
}
\description{
This function computes adjusted Wald confidence intervals from an original
study and a follow-up study where the effect size is a G-index of agreement.
Adjusted Wald confidence intervals for the difference and average effect
size are also computed. The confidence level for the difference is
1 – 2*alpha, which is recommended for equivalence testing. As a measurement
of agreement, the G-index is usually preferred to Cohen's kappa.
}
\examples{
replicate.agree(.05, 85, 100, 160, 200, 2)

# Should return:
#                       Estimate         SE         LL        UL
# Original:                 0.70 0.07252105  0.53093828 0.8152156
# Follow-up:                0.60 0.05661961  0.47726289 0.6992077
# Original - Follow-up:     0.10 0.09159681 -0.05844824 0.2428784
# Average:                  0.65 0.04579840  0.55040374 0.7299302


}
\references{
\insertRef{Bonett2022}{vcmeta}
}
