% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/compare.vectors.and.return.text.analysis.of.overlap.R
\name{compare.vectors.and.return.text.analysis.of.overlap}
\alias{compare.vectors.and.return.text.analysis.of.overlap}
\title{Create a Markdown report from the output of \code{\link{compare.vectors}}}
\usage{

  compare.vectors.and.return.text.analysis.of.overlap(named_list_of_vectors_to_compare,
  degrees_of_comparison_to_include = NULL, cat_immediately = FALSE,
  draw_venn_diagrams = FALSE, viewport_npc_width_height_for_images = 1,
  vector_colors_for_venn_diagrams = NULL, save_venn_diagram_files = FALSE,
  location_for_venn_diagram_files = "", prefix_for_venn_diagram_files = "",
  saved_venn_diagram_resolution_ppi = 300,
  saved_venn_diagram_dimension_units = "in", saved_venn_diagram_width = 8,
  saved_venn_diagram_height = 6, base_heading_level_to_use = 1)
}
\arguments{
\item{named_list_of_vectors_to_compare}{A named list of vectors to compare (see, for example, \code{\link{example.vectors.list}}). Duplicate values in a given vector will only be counted once (for example, c("a", "a", "b", "c") will be treated identically to c("a", "b", "c").}

\item{degrees_of_comparison_to_include}{A number or vector of numbers of which degrees of comparison to print (for example, 'c(2, 5)' would print only 2- and 5-way vector comparisons).}

\item{cat_immediately}{A logical (TRUE/FALSE) indicator whether to immediately print the output, as in an RMarkdown document.}

\item{draw_venn_diagrams}{A logical (TRUE/FALSE) indicator whether to draw Venn diagrams for all 2- through 5-way comparisons of vectors.}

\item{viewport_npc_width_height_for_images}{The scale at which to print an image. If the image is cut off at its edges, for example, this can be set lower than 1.0.}

\item{vector_colors_for_venn_diagrams}{An optional vector of color names for Venn diagrams (if \code{draw_venn_diagrams} is \code{TRUE}). Color names are applied to the named vectors in \code{named_list_of_vectors_to_compare} in their order in \code{named_list_of_vectors_to_compare}. If this is blank, a random color will be selected for each vector. Either way, each vector will have a consistent color across the Venn diagrams in which it appears.}

\item{save_venn_diagram_files}{A logical (TRUE/FALSE) indicator whether to save Venn diagrams as PNG files.}

\item{location_for_venn_diagram_files}{An optional string giving a directory into which to save Venn diagram PNG files (if \code{save_venn_diagram_files} is \code{TRUE}). This location must already exist on the filesystem.}

\item{prefix_for_venn_diagram_files}{An optional string giving a prefix to prepend to saved Venn diagram PNG files (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_resolution_ppi}{An optional number giving a resolution (PPI) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_dimension_units}{An optional string giving units for specifying \code{saved_venn_diagram_width} and \code{saved_venn_diagram_height} (if \code{save_venn_diagram_files} is \code{TRUE}). Can be \code{px} (pixels), \code{in} (inches, the default), \code{cm}, or \code{mm}.}

\item{saved_venn_diagram_width}{The width (in \code{saved_venn_diagram_dimension_units} units) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_height}{The height (in \code{saved_venn_diagram_dimension_units} units) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{base_heading_level_to_use}{An integer indicating the highest-level heading to print. Defaults to \code{1} (i.e., start by using first-level headings); \code{1} is also the minimum value used.}
}
\value{
A string of Markdown (and Venn diagrams, if \code{draw_venn_diagrams} is \code{TRUE}).

If \code{cat_immediately} is \code{TRUE}, nothing is returned by the function; rather, the output Markdown is printed immediately (for example, as part of a Knitted RMarkdown document, or to the console).

If \code{cat_immediately} is \code{FALSE}, the output can be saved to an object (as in the example below). This object can then be printed using \code{cat()}.

NOTE WELL: If \code{cat_immediately} is \code{FALSE}, the output \emph{should} be saved to an object. If it is not, R will give an error message when printing to the console, because of unescaped special characters (which work correctly when \code{cat()} is used).
}
\description{
This function is a wrapper for \code{\link{compare.vectors}}. It creates a Markdown report of all degrees of set comparisons between a named list of vectors.
}
\details{
Use of this function is illustrated with the \code{Veccompare Overlap Report} RMarkdown template for RStudio that is installed as part of the \pkg{veccompare} package.
}
\examples{
example <- compare.vectors.and.return.text.analysis.of.overlap(
    veccompare::example.vectors.list,
    cat_immediately = FALSE,
    draw_venn_diagrams = FALSE
)
cat(example)
}
