% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_gps.R
\name{get_select_params}
\alias{get_select_params}
\title{Extract Parameter Grid for Selected Configurations}
\usage{
get_select_params(x, smd_group = NULL)
}
\arguments{
\item{x}{A \code{select_result} object returned by \code{select_opt()}.}

\item{smd_group}{Optional character vector of SMD groups
(e.g. \code{"0.10-0.15"}). If provided, the returned data.frame
is subsetted to these groups. If \code{NULL}, all rows are returned.}
}
\value{
A data.frame with the parameter combinations corresponding
to the selected configurations.
}
\description{
Extract Parameter Grid for Selected Configurations
}
\examples{
\donttest{
# Define formula and set up optimization
formula_cancer <- formula(status ~ age * sex)
opt_args <- make_opt_args(cancer, formula_cancer, gps_method = "m1")
withr::with_seed(8252, {
  opt_results <- optimize_gps(
    data = cancer,
    formula = formula_cancer,
    opt_args = opt_args,
    n_iter = 2000
  )
})
# Select optimal combinations prioritizing SMD balance and matching in key
# groups
select_results <- select_opt(
  x = opt_results,
  smd_groups = list(
    c("adenoma", "control"),
    c("control", "crc_benign"),
    c("crc_malignant", "control")
  ),
  smd_variables = "age",
  smd_type = "max",
  perc_matched = c("adenoma", "crc_malignant")
)

# Extract the parameter grid from select_results for smd_group = "0.05-0.10"
get_select_params(select_results, smd_group = "0.05-0.10")
}
}
