% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAbundanceAnomaly.R
\name{getAbundanceAnomaly}
\alias{getAbundanceAnomaly}
\title{Get Abundance Anomaly}
\usage{
getAbundanceAnomaly(
  collections,
  interval,
  target_year,
  agency = NULL,
  species = NULL,
  trap = NULL,
  sex = "female",
  trapnight_min = 1,
  trapnight_max = NULL,
  separate_by = NULL
)
}
\arguments{
\item{collections}{Collections data retrieved from `getArthroCollections()`}

\item{interval}{Calculation interval for abundance, accepts “CollectionDate”,“Biweek”,“Week”, and “Month}

\item{target_year}{Year to calculate analysis on. Collections data must have a year range of at least (target_year - 5, target_year)}

\item{agency}{An optional vector for filtering agency by character code}

\item{species}{Character vector for filtering species. View species in your data `unique(data$species_display_name)`. Defaults to all species if no selection}

\item{trap}{Character vector for filtering trap type by acronym. View trap types in your data`unique(data$trap_acronym`. Defaults to all trap types}

\item{sex}{Character vector for filtering sex type. View sex options `unique(data$sex_type`). Defaults to "female".}

\item{trapnight_min}{Minimum trap night restriction for calculation. Default is 1.}

\item{trapnight_max}{Maximum trap night restriction for calculation. Default is no restriction.}

\item{separate_by}{Separate/group the calculation by 'trap','species', 'agency','county', or 'spatial'. Default NULL does not separate.}
}
\value{
Abundance anomaly calculation
}
\description{
`getAbundanceAnomaly(...) `requires at least five years prior to the target_year of arthro collections data to calculate for the specified parameters. The function uses the methods of the Gateway Abundance Anomaly calculator, and will not work if there is fewer than five years of data present.
}
\examples{
getAbundanceAnomaly(sample_collections,"Biweek",target_year=2020, species="Cx pipiens")

}
\keyword{abundance}
