% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier.vegclust.R
\name{hier.vegclust}
\alias{hier.vegclust}
\alias{random.vegclust}
\alias{hier.vegclustdist}
\alias{random.vegclustdist}
\title{Clustering with several number of clusters}
\usage{
hier.vegclust(
  x,
  hclust,
  cmin = 2,
  cmax = 20,
  min.size = NULL,
  verbose = TRUE,
  ...
)

random.vegclust(
  x,
  cmin = 2,
  cmax = 20,
  nstart = 10,
  min.size = NULL,
  verbose = TRUE,
  ...
)

hier.vegclustdist(
  x,
  hclust,
  cmin = 2,
  cmax = 20,
  min.size = NULL,
  verbose = TRUE,
  ...
)

random.vegclustdist(
  x,
  cmin = 2,
  cmax = 20,
  nstart = 10,
  min.size = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{For \code{hier.vegclust} and \code{random.vegclust}, a site (rows) by species (columns) matrix or data frame. For \code{hier.vegclustdist} and \code{random.vegclustdist}, a square distance matrix.}

\item{hclust}{A hierarchical clustering represented in an object of type \code{\link{hclust}}.}

\item{cmin}{Number of minimum mobile clusters.}

\item{cmax}{Number of maximum mobile clusters.}

\item{min.size}{If \code{min.size != NULL}, it specifies the minimum size of clusters. If some clusters are smaller, the algorithm will return the solutions corresponding to lower numbers of clusters.}

\item{verbose}{Flag used to print which number of clusters is currently running.}

\item{...}{Additional parameters for function \code{\link{vegclust}} or \code{\link{vegclustdist}}.}

\item{nstart}{A number indicating how many random trials should be performed for each number of groups}
}
\value{
Returns an object of type 'mvegclust' (multiple vegclust), which contains a list vector with objects of type \code{\link{vegclust}}.
}
\description{
Performs several runs of function 'vegclust' (or 'vegclustdist') on a community data matrix (or distance matrix) using different number of clusters
}
\details{
Function \code{hier.vegclust} takes starting cluster configurations from cuts of a dendrogram given by object \code{hclust}. Function \code{random.vegclust} chooses random objects as cluster centroids and for each number of clusters performs \code{nstart} trials. Functions \code{hier.vegclustdist} and \code{random.vegclustdist} are analogous to \code{hier.vegclust} and \code{random.vegclust} but accept distance matrices as input.
}
\examples{
## Loads data  
data(wetland)

## This equals the chord transformation 
wetland.chord <- as.data.frame(sweep(as.matrix(wetland), 1, 
                                    sqrt(rowSums(as.matrix(wetland)^2)), "/"))

## Create noise clustering from hierarchical clustering at different number of clusters
wetland.hc <- hclust(dist(wetland.chord),method="ward") 
wetland.nc1 <- hier.vegclust(wetland.chord, wetland.hc, cmin=2, cmax=5, 
                             m = 1.2, dnoise=0.75, method="NC")

## Create noise clustering from random seeds at different levels
wetland.nc2 <- random.vegclust(wetland.chord, cmin=2, cmax=5, nstart=10,
                               m = 1.2, dnoise=0.75, method="NC")
}
\seealso{
\code{\link{vegclust}}, \code{\link{vegclustdist}}, \code{\link{vegclass}}, \code{\link{defuzzify}}, \code{\link{hclust}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF
}
