% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2coverconvert.R
\name{df2coverconvert}
\alias{df2coverconvert}
\alias{df2coverconvert.list}
\alias{df2coverconvert,list-method}
\alias{df2coverconvert.data.frame}
\alias{df2coverconvert,data.frame-method}
\title{Create coverconvert objects}
\usage{
df2coverconvert(x, ...)

\method{df2coverconvert}{list}(x, ...)

\method{df2coverconvert}{data.frame}(x, name, ...)
}
\arguments{
\item{x}{Either a data frame or a list of data frames containing the
conversion table. Three columns are mandatory in such data frames, namely
\strong{value} (factor with the symbols for each class in the cover scale,
sorted from the lowest to the highest value), \strong{bottom} (numeric value
with the bottom values of each class), and \strong{top} (numeric value with
the top values of each class). The values \strong{bottom} and \strong{top} are
usually as cover percentage but they may refer to any other numeric
abundance.}

\item{...}{Further arguments passed among methods.}

\item{name}{A character value used as name of the cover scale in the data
frame method. In the list method, this name will be extracted from the
names of the elements in the list.}
}
\description{
The class \linkS4class{coverconvert} contains tables for transforming cover values
to percentage using the function \code{\link[=cover_trans]{cover_trans()}}.
These objects can be created from conversion tables imported as data frames.
}
\examples{
## Convert object into list
cov <- as(Kenya_veg@coverconvert, "list")

## Convert back to coverconvert
cov <- df2coverconvert(cov)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
