% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weave-diffs.R
\name{weave_diffs_long}
\alias{weave_diffs_long}
\alias{weave_diffs_wide}
\title{Get differences in context}
\usage{
weave_diffs_long(comparison, column = everything())

weave_diffs_wide(comparison, column = everything(), suffix = NULL)
}
\arguments{
\item{comparison}{The output of \code{compare()}}

\item{column}{<\code{\link[=versus_tidy_select]{tidy-select}}>. A row will be in the output if
the comparison shows differing values for any columns matching this argument}

\item{suffix}{A character vector of length 2 providing suffixes appended to
the renamed columns in \code{weave_diffs_wide()}. Set to \code{NULL} (the default) to
use \code{paste0("_", table_id)}. The first suffix is applied to values from
\code{table_a}, the second to values from \code{table_b}.}
}
\value{
\item{\code{weave_diffs_wide()}}{The input \code{table_a} filtered to rows where
differing values exist for one of the columns selected by \code{column}.
The selected columns with differences will be in the result twice, one for
each input table.}

\item{\code{weave_diffs_long()}}{Input tables are filtered to rows where
differing values exist for one of the columns selected by \code{column}.
These two sets of rows (one for each input table) are interleaved row-wise.}
}
\description{
Get differences in context
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
comp |> weave_diffs_wide(disp)
comp |> weave_diffs_wide(c(mpg, disp))
comp |> weave_diffs_wide(c(mpg, disp), suffix = c("", "_new"))
comp |> weave_diffs_long(disp)
comp |> weave_diffs_long(c(mpg, disp))
}
