% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_table.R
\name{summary_table}
\alias{summary_table}
\title{Print a standardised summary table}
\usage{
summary_table(
  mean,
  var,
  quant,
  ic95 = NULL,
  prop0 = NULL,
  prop1 = NULL,
  label,
  digits = 2,
  ...
)
}
\arguments{
\item{mean}{Real.}

\item{var}{Real.}

\item{quant}{Named numeric vector. Names must be of the form "xx%" with
numeric xx. As from the output of the function \code{quantile}.}

\item{ic95}{Numeric vector.}

\item{prop0}{Real.}

\item{prop1}{Real.}

\item{label}{Character. Name of the summarised variable.}

\item{digits}{Integer. Number of decimal places to be used.}

\item{...}{Passed to knitr::kable().}
}
\value{
A knitr_kable object.
}
\description{
Make a table of several summary statistics with proper formatting.
}
\details{
The table includes the mean, variance and standard deviation, a vector of 3
quantiles at 0.05, 0.50 and 0.95, a 95% centred confidence interval and a
numeric value to be interpreted as a proportion above 0 and 1. All values are
rounded to the specified number of decimal places.
}
\examples{
summary_table(mean = 1, var = 1, quant = quantile(1:10, 0:4/4), ic95 = 4:5,
prop1 = .6, label = "test")
}
