% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visFocus.R
\name{visFocus}
\alias{visFocus}
\title{Network visualization focus method}
\usage{
visFocus(
  graph,
  id,
  scale = 2,
  offset = list(x = 0, y = 0),
  locked = TRUE,
  animation = list(duration = 1500, easingFunction = "easeInOutQuad")
)
}
\arguments{
\item{graph}{: a \code{ \link[visNetwork]{visNetworkProxy}}  object}

\item{id}{: a node id}

\item{scale}{: Optional. Number. The scale is the target zoomlevel. Default value is 2.0.}

\item{offset}{: Optional. List. The offset (in DOM units) is how many pixels from the center the view is focussed. Default value is list(x = 0, y = 0).}

\item{locked}{: Optional. Boolean. Locked denotes whether or not the view remains locked to the node once the zoom-in animation is finished. Default value is true.}

\item{animation}{: Optional. List. For animation you can define the duration (in milliseconds) and easing function manually. 
Available are: linear, easeInQuad, easeOutQuad, easeInOutQuad, easeInCubic, easeOutCubic, easeInOutCubic, easeInQuart, easeOutQuart, easeInOutQuart, easeInQuint, easeOutQuint, easeInOutQuint.
Default to list(duration = 1500, easingFunction = "easeInOutQuad")}
}
\description{
For use focus() method in a shiny app. For full documentation, have a look at  \link[visNetwork]{visDocumentation}.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visNodes} for nodes options,  \link[visNetwork]{visEdges} for edges options,  \link[visNetwork]{visGroups} for groups options, 
\link[visNetwork]{visLegend} for adding legend,  \link[visNetwork]{visOptions} for custom option,  \link[visNetwork]{visLayout} &  \link[visNetwork]{visHierarchicalLayout} for layout, 
\link[visNetwork]{visPhysics} for control physics,  \link[visNetwork]{visInteraction} for interaction,  \link[visNetwork]{visNetworkProxy} &  \link[visNetwork]{visFocus} &  \link[visNetwork]{visFit} for animation within shiny,
\link[visNetwork]{visDocumentation},  \link[visNetwork]{visEvents},  \link[visNetwork]{visConfigure} ...
}
