% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSummary.R
\name{tableSummary}
\alias{tableSummary}
\title{Create a summary table}
\usage{
tableSummary(
  audioData,
  by = c(),
  measures = c("duration", "voice_breaks_percent", "RMS_env", "mean_loudness", "mean_F0",
    "sd_F0", "mean_entropy", "mean_HNR"),
  nameMeasures = c(),
  figureNumber = 1
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{by}{A character vector indicating the name of the factor(s).}

\item{measures}{A character vector indicating the name of the variables to be included in the table.}

\item{nameMeasures}{Optional character vector indicating the names to be displayed for each of the different measures in the output table. If no value is provided, original variable names are displayed.}

\item{figureNumber}{Integer indicating figure number, used to create the title for the table. Default corresponds to 1.}
}
\value{
HTML file summarizing the main descriptive statistics for each variable, conditioned by group(s) if one or more factors are provided.
}
\description{
Automatically generates HTML table with the main descriptive statistics (mean, standard deviation and number of data points) for each variable of the data set. Descriptive statistics can be conditioned by groups if grouping variables are defined.
}
\examples{
tableSummary(testAudioData, by = c("Condition", "Dimension"),
measures = c("duration", "voice_breaks_percent", "RMS_env", "mean_loudness",
"mean_F0"))

}
