% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_chords.R
\name{check_chords}
\alias{check_chords}
\title{Check chords}
\usage{
check_chords(x, window = 3, try_perm = FALSE)
}
\arguments{
\item{x}{A vector containing a sequence of musical notes.}

\item{window}{Size of window of notes to be checked. Default: \code{3}.}

\item{try_perm}{Logical. Must try all notes permutations of notes? Default: \code{FALSE}.}
}
\description{
Check the sequence of musical notes for chords.
}
\examples{
\dontrun{
library(voice)
check_chords(c('C','E','G'), window = 3, try_perm = FALSE)
check_chords(c('C','E','G'), window = 3, try_perm = TRUE)
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern = glob2rx('*.wav'), full.names = TRUE)
M <- extract_features(path2wav)
M$gain[is.na(M$f0)] <- NA
# assigning notes
f0_spn <- assign_notes(M, fmt = 0)
check_chords(f0_spn, window = 3, try_perm = FALSE)
check_chords(f0_spn, window = 3, try_perm = TRUE)
check_chords(f0_spn, window = 4, try_perm = TRUE)
}
}
