% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_shortPutCondorPnL.R
\name{shortPutCondorPnL}
\alias{shortPutCondorPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Short Put Condor Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
shortPutCondorPnL(
  ST,
  X1L,
  X2Ml,
  X3Mu,
  X4H,
  P1L,
  P2Ml,
  P3Mu,
  P4H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM shorted Put.}

\item{X2Ml}{Middle-low Strike Price or eXercise price for middle strike bought Put.}

\item{X3Mu}{Middle-upper Strike Price or eXercise price for middle strike bought Put.}

\item{X4H}{Higher Strike Price or eXercise price for one OTM shorted Put.}

\item{P1L}{Put Premium or Put Price received for the one OTM shorted Put.}

\item{P2Ml}{Put Premium or Put Price paid for the middle-low bought Put.}

\item{P3Mu}{Put Premium or Put Price paid for the middle-upper bought Put.}

\item{P4H}{Put Premium or Put Price received for the one ITM shorted Put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a short position in an OTM Put option with a strike price X1L, a long position in an OTM Put option with a higher strike price X2Ml, a long position in an ITM Put option with a strike price X3Mu, and a short position in an ITM Put option with a higher strike price X4H. All strikes are equidistant: X4H minus X3Mu equals to X3Mu minus X2Ml; equals to X2Mu minus X1L. This is a relatively low net credit trade. As with a short put butterfly, the potential reward is sizably smaller than with a short straddle or a short strangle (albeit with a lower risk). So, this is a capital gain (rather than an income) strategy. The trader or investor has neutral outlook (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Short Put Condor Option Strategy and draw its graph in the Plots tab.
}
\examples{
shortPutCondorPnL(52,45,50,55,60,2,3,7,10.)
shortPutCondorPnL(425,400,420,440,460,16,22,35,50,hl=0.9,hu=1.125)
}
