% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcn_threads.R
\name{tcn_threads}
\alias{tcn_threads}
\title{Get threaded conversation tweets}
\usage{
tcn_threads(
  tweet_ids = NULL,
  token = NULL,
  endpoint = "recent",
  start_time = NULL,
  end_time = NULL,
  annotations = FALSE,
  max_results = NULL,
  max_total = NULL,
  retry_on_limit = TRUE,
  skip_list = NULL,
  verbose = TRUE
)
}
\arguments{
\item{tweet_ids}{List. Tweet ids of any tweet that are part of the threaded conversations of interest. Also accepts a
list of tweet URLs or a mixed list.}

\item{token}{List. Twitter API tokens.}

\item{endpoint}{Character string. Twitter API v2 search endpoint. Can be either "recent" for the last 7 days or "all"
if users app has access to historical "full-archive" tweets. Default is "recent".}

\item{start_time}{Character string. Earliest tweet timestamp to return (UTC in ISO 8601 format). If NULL API will
default to 30 days before end_time. Default is NULL.}

\item{end_time}{Character string. Latest tweet timestamp to return (UTC in ISO 8601 format). If NULL API will default
to now - 30 seconds. Default is NULL.}

\item{annotations}{Logical. Include tweet context annotation field in results. If TRUE Twitter imposes a max_results
limit of 100. Default is FALSE.}

\item{max_results}{Numeric. Set maximum number of tweets to collect per API v2 request. Up to 100 tweets for standard
or 500 tweets for academic projects can be collected per request. Default is NULL to set maximum allowed.}

\item{max_total}{Numeric. Set maximum total number of tweets to collect as a cap limit precaution. Will only be
accurate to within one search request count (being max_results, or 100 for standard or 500 tweets for academic
project). This will not be ideal for most cases as an API search generally retrieves the most recent tweets first
(reverse-chronological order), therefore the beginning part of the last conversation thread may be absent. Default
is NULL.}

\item{retry_on_limit}{Logical. When the API v2 rate-limit has been reached wait for reset time. Default
is TRUE.}

\item{skip_list}{Character vector. List of tweet conversation IDs to skip searching if found.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A named list. Dataframes of tweets, users, errors and request metadata.
}
\description{
Collects tweets that share the same Twitter conversation ID as supplied tweets.
}
\examples{
\dontrun{
# get twitter conversation threads by tweet ids or urls
tweet_ids <- c("xxxxxxxx",
               "https://twitter.com/xxxxxxxx/status/xxxxxxxx")
tweets <- tcn_threads(tweet_ids, token, endpoint = "recent")

# get twitter conversation threads by tweet ids or urls using historical endpoint
# starting from May 01, 2021.
tweet_ids <- c("xxxxxxxx",
               "https://twitter.com/xxxxxxxx/status/xxxxxxxx")
tweets <- tcn_threads(tweet_ids,
                      token = token,
                      endpoint = "all",
                      start_time = "2021-05-01T00:00:00Z")
}

}
