% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_rtoot.R, R/zzz.R
\name{ImportRtoot}
\alias{ImportRtoot}
\alias{import_rtoot}
\title{Import rtoot collected data}
\usage{
ImportRtoot(data)

import_rtoot(data)
}
\arguments{
\item{data}{Character string or dataframe. File path to or tibble of collected data from \pkg{rtoot}.}
}
\value{
A dataframe suitable for input into mastodon network \code{\link{Create}} functions.
}
\description{
Imports \pkg{rtoot} collected data from \code{rda} or \code{rds} saved object file or from an rtoot
dataframe. Ensures \code{datasource} and specified \code{socialmedia} type are set so data is usable by
\code{\link{Create}} functions. Not required if collected data was collected by \code{vosonSML} and saved as an
\code{rds} file, use \code{\link{readRDS}} instead.
}
\note{
Only supports \pkg{rtoot} data collected using the \code{\link[rtoot]{get_timeline_hashtag}},
\code{\link[rtoot]{get_timeline_public}}, \code{\link[rtoot]{get_status}}, \code{\link[rtoot]{get_context}}
functions.
}
\examples{
\dontrun{
# import rtoot collected data from dataframe
collect_mast <- ImportRtoot(rtoot_data)

# import rtoot collected data from file
collect_mast <- ImportRtoot("./rtoot_search_n100.rds")
}

}
