% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_spectra.R
\name{filter_spectra}
\alias{filter_spectra}
\title{Filter spectral data frame based on Mahalanobis distance}
\usage{
filter_spectra(df, filter, return.distances, num.col.before.spectra,
  window.size, verbose)
}
\arguments{
\item{df}{\code{data.frame} object containing columns of spectra and rows of
observations. Spectral columns must be labeled with an "X" and then the
wavelength (example: "X740" = 740nm). Left-most column must be unique ID.
May also contain columns of metadata between the unique ID and spectral
columns. Cannot contain any missing values. Metadata column names may not
start with "X".}

\item{filter}{boolean that determines whether or not the input
\code{data.frame} will be filtered. If \code{TRUE}, \code{df} will be
filtered according to squared Mahalanobis distance with a 95\% cutoff from
a chi-square distribution with degrees of freedom = number of spectral
columns. If \code{FALSE}, a column of squared Mahalanobis distances
\code{h.distance} will be added to the right side of df and all rows will
be returned. Default is \code{TRUE}.}

\item{return.distances}{boolean that determines whether a column of squared
Mahalanobis distances will be included in output \code{data.frame}. If
\code{TRUE}, a column of Mahalanobis distances for each row will be added
to the right side of \code{df}. Default is \code{FALSE}.}

\item{num.col.before.spectra}{number of columns to the left of the spectral
matrix in \code{df}. Default is 4.}

\item{window.size}{number defining the size of window to use when calculating
the covariance of the spectra (required to calculate Mahalanobis distance).
Default is 10.}

\item{verbose}{If \code{TRUE}, the number of rows removed through filtering
will be printed to the console. Default is \code{TRUE}.}
}
\value{
If \code{filter} is \code{TRUE}, returns filtered data frame
  \code{df} and reports the number of rows removed. The Mahalanobis distance
  with a cutoff of 95\% of chi-square distribution (degrees of freedom =
  number of wavelengths) is used as filtering criteria. If \code{filter} is
  \code{FALSE}, returns full input df with column \code{h.distances}
  containing the Mahalanobis distance for each row.
}
\description{
Determine Mahalanobis distances of observations (rows) within a
  given \code{data.frame} with spectral data. Option to filter out
  observations based on these distances.
}
\details{
This function uses a chi-square distribution with 95\% cutoff where
  degrees of freedom = number of wavelengths (columns) in the input
  \code{data.frame}.
}
\examples{
library(magrittr)
filtered.test <- ikeogu.2017 \%>\%
  dplyr::select(-TCC) \%>\%
  na.omit() \%>\%
  filter_spectra(
    df = .,
    filter = TRUE,
    return.distances = TRUE,
    num.col.before.spectra = 5,
    window.size = 15
  )
filtered.test[1:5, c(1:5, (ncol(filtered.test) - 5):ncol(filtered.test))]
}
\references{
Johnson, R.A., and D.W. Wichern. 2007. Applied Multivariate
  Statistical Analysis (6th Edition). pg 189
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
