% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_detection.R
\name{find_peaks}
\alias{find_peaks}
\title{Function to find peaks of an EDA datafile}
\usage{
find_peaks(
  data,
  offset = 1,
  start_WT = 4,
  end_WT = 4,
  thres = 0.005,
  sample_rate = getOption("SAMPLE_RATE", 8)
)
}
\arguments{
\item{data}{DataFrame with EDA as one of the columns and indexed by a datetimeIndex}

\item{offset}{the number of rising seconds and falling seconds after a peak needed to be counted as a peak}

\item{start_WT}{maximum number of seconds before the apex of a peak that is the "start" of the peak}

\item{end_WT}{maximum number of seconds after the apex of a peak that is the "end" of the peak 50 percent of amp}

\item{thres}{the minimum microsecond change required to register as a peak, defaults as .005}

\item{sample_rate}{number of samples per second, default=8}
}
\value{
data frame with several columns
  peaks               1 if apex
  peak_start          1 if start of peak
  peak_end            1 if end of preak
  peak_start_times    if apex then corresponding start timestamp
  peak_end_times      if apex then corresponding end timestamp
  half_rise           if sharp decaying apex then time to halfway point in rise
  amp                 if apex then value of EDA at apex - value of EDA at start
  max_deriv           if apex then max derivative within 1 second of apex
  rise_time           if apex then time from start to apex
  decay_time          if sharp decaying apex then time from apex to end
  SCR_width           if sharp decaying apex then time from half rise to end
}
\description{
This function finds the peaks of an EDA signal and adds
  basic properties to the datafile.
}
\details{
Also, peak_end is assumed to be no later than the start of the next peak.
  Is that OK?
}
