% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_ag_bulletin.R
\name{parse_ag_bulletin}
\alias{parse_ag_bulletin}
\title{Parse BOM Agriculture Bulletin XML Files}
\usage{
parse_ag_bulletin(state, filepath)
}
\arguments{
\item{state}{Required value of an Australian state or territory as full name
or postal code.  Fuzzy string matching via \code{\link[base:agrep]{base::agrep()}} is done.}

\item{filepath}{A string providing the directory location of the précis
file(s) to parse.  See Details for more.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of Australia \acronym{BOM} agricultural
bulletin information.
}
\description{
\strong{Defunct:} This function is defunct as of version 2.0.0 because the
underlying BOM agricultural forecast bulletin service is no longer available.
}
\details{
Parse local \acronym{BOM} agriculture bulletin \acronym{XML} file(s) for a
specified state or territory or all Australia.  Ported from \pkg{bomrang}.

Allowed state and territory postal codes, only one state per request
or all using \code{AUS}.
\describe{
\item{AUS}{Australia, returns forecast for all states, NT and ACT}
\item{ACT}{Australian Capital Territory (will return NSW)}
\item{NSW}{New South Wales}
\item{NT}{Northern Territory}
\item{QLD}{Queensland}
\item{SA}{South Australia}
\item{TAS}{Tasmania}
\item{VIC}{Victoria}
\item{WA}{Western Australia}
}

The \var{filepath} argument will only accept a directory where files
are located for parsing. DO NOT supply the full path including the file
name.  This function will only parse the requested state or all of
Australia in the same fashion as \code{\link[=get_precis_forecast]{get_precis_forecast()}}, provided that the
files are all present in the directory.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# parse the ag bulletin for Western Australia

# download to tempfile() using basename() to keep original name
utils::download.file(url = "ftp://ftp.bom.gov.au/anon/gen/fwo/IDQ60604.xml",
              destfile = file.path(tempdir(),
              basename("ftp://ftp.bom.gov.au/anon/gen/fwo/IDQ60604.xml")),
              mode = "wb")

parse_ag_bulletin(state = "QLD", filepath = tempdir())
\dontshow{\}) # examplesIf}
}
\references{
Agricultural observations are retrieved from the Australian Bureau of
Meteorology (\acronym{BOM}) Weather Data Services Agriculture Bulletins,\cr
\url{http://www.bom.gov.au/catalogue/observations/about-agricultural.shtml}.

and

Australian Bureau of Meteorology (\acronym{BOM})) Weather Data Services
Observation of Rainfall, \cr
\url{http://www.bom.gov.au/climate/how/observations/rain-measure.shtml}.

Station location and other metadata are sourced from the Australian Bureau of
Meteorology (\acronym{BOM}) webpage, Bureau of Meteorology Site Numbers:\cr
\url{http://www.bom.gov.au/climate/cdo/about/site-num.shtml}.
}
\seealso{
\link{get_ag_bulletin}

Other BOM: 
\code{\link{find_forecast_towns}()},
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other parse: 
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}, and Paul
Melloy, \email{paul@melloy.com.au}
}
\concept{BOM}
\concept{parse}
