% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_parse_messages}
\alias{whapi_parse_messages}
\title{Parse Whapi "messages" array into a normalized tibble}
\usage{
whapi_parse_messages(
  lst,
  channel_id = NULL,
  event_type = NULL,
  event_act = NULL
)
}
\arguments{
\item{lst}{A list or single object representing Whapi webhook \code{messages}.
Accepts \code{NULL}, a single message, or an array of messages.}

\item{channel_id}{Character. Channel identifier (usually passed down from
\code{\link[=whapi_flatten_webhook]{whapi_flatten_webhook()}}).}

\item{event_type}{Character. Event type (\code{"messages"} by default).}

\item{event_act}{Character. Event action (\code{"post"} by default).}
}
\value{
A tibble with one row per message. Includes contextual columns
(\code{channel_id}, \code{event_type}, \code{event_action}).
}
\description{
Converts the webhook field \code{messages} (from Whapi.Cloud) into a \strong{row-per-message}
tibble with a stable schema.
It extracts common metadata (ids, chat, author, timestamps, source), plain text
content, action edits/reactions, and \strong{interactive replies} along with the
\strong{quoted context} (headers, body, sections/buttons as JSON).
}
\details{
\itemize{
\item Handles multiple shapes and normalizes to a list of messages via a helper
\code{whapi_as_array(lst, "message")}.
\item Reply types supported:
\itemize{
\item \code{reply$type == "list_reply"} -> uses \code{reply$list_reply$id/title/description}
\item \code{reply$type == "buttons_reply"} (or \code{"button_reply"}) -> uses
\code{reply$buttons_reply$id/title} (or \code{reply$button_reply})
\item Fallback: \code{reply$id/title/description/body} when available
}
\item Context of the quoted message is captured in:
\code{context_quoted_id}, \code{context_quoted_author}, \code{context_header}, \code{context_body},
\code{context_label}, \code{context_footer}, and serialized JSON for \code{sections} and \code{buttons}
(\code{context_sections_json}, \code{context_buttons_json}) via \code{whapi_to_pretty_json()}.
\item The column \code{change} is set to \code{"reply"} for reply messages, \code{"reactions"} when a
reaction is present, or \code{"text"} for edit operations.
\item Time fields: \code{timestamp} (epoch seconds, numeric) and \code{timestamp_dt} (POSIXct UTC).
}
}
\keyword{internal}
