% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_impute.R
\name{check_impute}
\alias{check_impute}
\title{Checking Imputation Info}
\usage{
check_impute(imputation_information, current_data, current_period)
}
\arguments{
\item{imputation_information}{The \code{success} element of the \code{imputation_information}
list created by \code{\link[=imputation_precompute]{imputation_precompute()}} for the given period.}

\item{current_data}{A tibble/data.table with only observations from the current sampling period.}

\item{current_period}{Numeric value of length 1; current treatment wave of the simulation.}
}
\description{
Subsets or adds to the tibble/data.frame created by \code{\link[=imputation_precompute]{imputation_precompute()}},
and sorts it to ensure compatibility with \code{\link[randomizr:block_ra]{randomizr::block_ra()}}.
}
\details{
\code{\link[randomizr:block_ra]{randomizr::block_ra()}} does not see the names
of the probabilities passed per block, so the imputation information must be subsetted
to only contain blocks which are present in a period, and sorted to comply with
\code{\link[randomizr:block_ra]{randomizr::block_ra()}}'s internal ordering.

When blocks are required but do not exist in the information provided it is added
to the tibble/data.table, with an estimated conditional probability of success as
the average across other blocks.

When blocks are present but not required, they are removed from the
tibble/data.table.
}
\keyword{internal}
