% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_rbf_interpolation}
\alias{wbt_lidar_rbf_interpolation}
\title{Lidar rbf interpolation}
\usage{
wbt_lidar_rbf_interpolation(
  input,
  output = NULL,
  parameter = "elevation",
  returns = "all",
  resolution = 1,
  num_points = 20,
  exclude_cls = NULL,
  minz = NULL,
  maxz = NULL,
  func_type = "ThinPlateSpline",
  poly_order = "none",
  weight = 5,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file (including extension).}

\item{output}{Output raster file (including extension).}

\item{parameter}{Interpolation parameter; options are 'elevation' (default), 'intensity', 'class', 'return_number', 'number_of_returns', 'scan angle', 'rgb', 'user data'.}

\item{returns}{Point return types to include; options are 'all' (default), 'last', 'first'.}

\item{resolution}{Output raster's grid resolution.}

\item{num_points}{Number of points.}

\item{exclude_cls}{Optional exclude classes from interpolation; Valid class values range from 0 to 18, based on LAS specifications. Example, --exclude_cls='3,4,5,6,7,18'.}

\item{minz}{Optional minimum elevation for inclusion in interpolation.}

\item{maxz}{Optional maximum elevation for inclusion in interpolation.}

\item{func_type}{Radial basis function type; options are 'ThinPlateSpline' (default), 'PolyHarmonic', 'Gaussian', 'MultiQuadric', 'InverseMultiQuadric'.}

\item{poly_order}{Polynomial order; options are 'none' (default), 'constant', 'affine'.}

\item{weight}{Weight parameter used in basis function.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Interpolates LAS files using a radial basis function (RBF) scheme. When the input/output parameters are not specified, the tool interpolates all LAS files contained within the working directory.
}
\keyword{LiDARTools}
