% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_wig.R
\name{import_wig}
\alias{import_wig}
\title{Imports a WIG file}
\usage{
import_wig(file_path, n = -1L)
}
\arguments{
\item{file_path}{A path to a WIG file.}

\item{n}{The (maximal) number of lines to read. Negative values indicate that
one should read up to the end of input on the connection.}
}
\value{
A tibble of three variables: \code{chr}, chromosome; \code{pos}, genomic
position; and \code{val}, value. Chromosome positions are 1-relative, i.e. the
first base is 1, as specified in WIG files.
}
\description{
\code{import_wig} reads a \href{https://m.ensembl.org/info/website/upload/wig.html}{WIG (wiggle)} file and
expands the data into long format, i.e., the each observation in the returned
tibble pertains the position of one single base.
}
\examples{
# Import a WIG file
wig_file <- system.file(
              "extdata",
              file = 'hg19-pik3ca.wig',
              package = "wig",
              mustWork = TRUE)

import_wig(wig_file)

}
