% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSimultaneous.R
\name{GetSimultaneous}
\alias{GetSimultaneous}
\title{Identify simultaneous fixes between trajectories}
\usage{
GetSimultaneous(traj1, traj2, tc = 0)
}
\arguments{
\item{traj1}{an object of the class \code{move2} which contains the time-stamped movement fixes of EXACTLY 1 individual. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes. For simplicity, \code{tc}
is always taken in seconds.}
}
\value{
A \code{move2} object containing two individuals, representing the two original \code{move2} 
objects, each containing only those fixes that are deemed simultaneous.
}
\description{
The function \code{GetSimultaneous} identifies and extracts simultaneous fixes, 
  within a given tolerance limit, between two movement trajectories.
}
\details{
This function is used to determine the simultaneous fixes between two movement 
  datasets facilitating further analysis.
}
\examples{
library(move2)
data(deer)
deer37 <- deer[mt_track_id(deer) == '37',]
deer38 <- deer[mt_track_id(deer) == '38',]
deer_sim <- GetSimultaneous(deer37, deer38, tc = 7.5*60)
table(deer$id)
table(deer_sim$id)

}
\seealso{
GetTO
}
\keyword{processing}
