% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estWD.R, R/weightedDistribution.R
\name{estWD}
\alias{estWD}
\alias{weightedDistribution}
\title{Weighted Distribution Estimation}
\usage{
estWD(fatDist, weightFun, distribution, ...)

weightedDistribution(fatDist, weightFun, distribution, ...)
}
\arguments{
\item{fatDist}{Vector of fatality distanes from the turbine.}

\item{weightFun}{R function that is multipled by the probability distribution, see details.}

\item{distribution}{Character indicating the distribution for \code{weightedDistribution} or vector for \code{estWD}.}

\item{...}{Additional arguments passed to \code{weightFun} or \code{\link[stats]{optim}}.}
}
\value{
Data frame of the parameter estimates with fit statistics.
}
\description{
Maximum likelihood estimatation of a weighted probability density function is completed. is done on a weighted distribution.
The weighted distribution is a typical probability density distribution multiplied by a weight function. The weight function can be used to truncate the distribution by returning zero beyond some threshold value.
}
\details{
The function \code{estWD} is a convient wrapper function to \code{weightedDistribution}, for fitting multiple distributions.

The weight function should return a (relative) probability of detection at every distance.
Typically this is the proportion of area searched.
The function \code{\link{weightFun}} is set up to take a table of proportion of area searched and return values in a function format.

Let \eqn{h(x)} be the weight function (\code{weightFun}), \eqn{f(x|\theta)} be a probability density function (specified by \code{distribution}, \eqn{x} be the vector of carcass distances from the turbine (\code{fatDist}), and \eqn{\theta} be the parameter vector to be estimated.
The weighted distribution is
\deqn{f_{d}(x|\theta) = \frac{h(x)f(x|\theta)}{\int h(y)f(y|\theta)dy}}
The likelihood that is maximized is
\deqn{L_{d}(\theta|\underbar{x}) = \prod_{i=1}^{n}\frac{h(x_i)f(x_i|\theta)}{\int h(y)f(y|\theta)dy}}
}
\examples{
## load the data
data(carcassDistance)
data(proportionAreaSearched)

###############################################
## fit for fall carcasses found on road and pad (RP)
distanceFallRP <- subset(carcassDistance,plotType=='RP'&season=='fall',
select=distanceFromTurbine,drop=TRUE)

\donttest{
fallRPFit <- estWD(fatDist=distanceFallRP,weightFun=weightFun,
distribution=c('norm','gamma','weibull'),propTable=proportionAreaSearched,type='RP',
typeCol='plotType',distanceCol='distanceFromTurbine',propCol='proportionAreaSearched',
maxDistance=100)
}

###############################################
## fit for fall carcasses found on full plots
distanceFallFP <- subset(carcassDistance,plotType=='FULL'&season=='fall',
select=distanceFromTurbine,drop=TRUE)

\donttest{
fallFPFit <- estWD(fatDist=distanceFallFP,weightFun=weightFun,
distribution=c('norm','gamma','weibull'),propTable=proportionAreaSearched,type='FULL',
typeCol='plotType',distanceCol='distanceFromTurbine',propCol='proportionAreaSearched',
maxDistance=100)
}

}
\seealso{
\code{\link{calcAC}}

\code{\link{weightFun}}
}
