% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{.workflow_postprocessor_requires_fit}
\alias{.workflow_postprocessor_requires_fit}
\alias{workflows-internals}
\alias{.fit_pre}
\alias{.fit_model}
\alias{.fit_post}
\alias{.fit_finalize}
\title{Internal workflow functions}
\usage{
.workflow_postprocessor_requires_fit(workflow)

.fit_pre(workflow, data)

.fit_model(workflow, control)

.fit_post(workflow, data)

.fit_finalize(workflow)
}
\arguments{
\item{workflow}{A workflow

For \code{.fit_pre()}, this should be a fresh workflow.

For \code{.fit_model()}, this should be a workflow that has already been trained
through \code{.fit_pre()}.

For \code{.fit_post()}, this should be a workflow that has already been trained
through \code{.fit_pre()} and \code{.fit_model()}.

For \code{.fit_finalize()}, this should be a workflow that has been through
both \code{.fit_pre()} and \code{.fit_model()}. If the workflow contains an optional
postprocessor, it should also have been trained through \code{.fit_post()}.}

\item{data}{A data frame of predictors and outcomes to use when fitting the
workflow}

\item{control}{A \code{\link[=control_workflow]{control_workflow()}} object}
}
\description{
\code{.fit_pre()}, \code{.fit_model()}, \code{.fit_post()} and \code{.fit_finalize()} are internal workflow
functions for \emph{partially} fitting a workflow object. They are only exported
for usage by the tuning package, \href{https://github.com/tidymodels/tune}{tune},
and the general user should never need to worry about them.
}
\examples{
\dontshow{if (rlang::is_installed("recipes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(parsnip)
library(recipes)
library(magrittr)

model <- linear_reg() |>
  set_engine("lm")

wf_unfit <- workflow() |>
  add_model(model) |>
  add_formula(mpg ~ cyl + log(disp))

wf_fit_pre <- .fit_pre(wf_unfit, mtcars)
wf_fit_model <- .fit_model(wf_fit_pre, control_workflow())
wf_fit <- .fit_finalize(wf_fit_model)

# Notice that fitting through the model doesn't mark the
# workflow as being "trained"
wf_fit_model

# Finalizing the workflow marks it as "trained"
wf_fit

# Which allows you to predict from it
try(predict(wf_fit_model, mtcars))

predict(wf_fit, mtcars)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
