% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_spatial.R
\name{ped_spatial}
\alias{ped_spatial}
\title{Get files for spatial representation of pedigree}
\usage{
ped_spatial(
  plottable,
  na.rm = TRUE,
  output = "list",
  fullsibdata = NULL,
  sibthreshold = 0,
  path = "",
  filename = "",
  out.format = "geopackage",
  time.limits = c(as.Date("1900-01-01"), as.Date("2100-01-01")),
  time.limit.rep = FALSE,
  time.limit.offspring = FALSE,
  time.limit.moves = FALSE
)
}
\arguments{
\item{plottable}{Data frame. Output of \code{\link[=plot_table]{plot_table()}} function.}

\item{na.rm}{Logical (\code{TRUE}/\code{FALSE}). Remove samples with missing coordinates and/or dates.}

\item{output}{Character vector specifying the desired output type ('list' - default or 'gis').
Available outputs: list: all spatial data returned as list, gis: all spatial data
returned as georeferenced files.}

\item{fullsibdata}{Data frame with COLONY full-sibling data.}

\item{sibthreshold}{Numeric. P-value threshold for sibship assignment.}

\item{path}{System path for storing georeferenced files.}

\item{filename}{Common name for all georeferenced files.}

\item{out.format}{Character string. Type of georeferenced files to be generated.
Can be ether \code{"geopackage"} or \code{"shapefile"}. Default is \code{"geopackage"}}

\item{time.limits}{Vector of two \code{Date} values as the time window.}

\item{time.limit.rep}{Logical (\code{TRUE}/\code{FALSE}). Apply time limits to
reference samples of reproductive animals.}

\item{time.limit.offspring}{Logical (\code{TRUE}/\code{FALSE}). Apply time limits to
reference samples of offspring.}

\item{time.limit.moves}{Logical (\code{TRUE}/\code{FALSE}). Apply time limits to
movement data.}
}
\value{
Depending on the \code{output} parameter the function can return a list of \code{\link[sf:sf]{sf}} objects,
a georeferenced vector data files or both.

Most of the objects are created separately for mothers, fathers and offspring,
this include:
\itemize{
\item Reference Points (\code{motherRpoints}, \code{fatherRpoints}, and \code{offspringRpoints}).
\itemize{
\item Each point corresponds to an animal included in the 'plot_table()'
function output.
\item For reproductive animals (mothers and fathers), a reference point is the
location of their last sample within the specified time window.
\item For offspring, the reference point is the location of their first sample
within the time window.
}
\item Movement Points (\code{motherMovePoints}, \code{fatherMovePoints}, and \code{offspringMovePoints}).
\itemize{
\item These points represent all the samples of the respective animals.
}
\item Movement Lines (\code{motherMoveLines}, \code{fatherMoveLines} and \code{offspringMoveLines}).
\itemize{
\item Movement lines connect all '...MovePoints' of a specific animal in
chronological order.
}
\item Movement Polygons (\code{motherMovePolygons}, \code{fatherMovePolygons} and \code{offspringMovePolygons}):
\itemize{
\item Movement polygons represent a convex hull that encloses all the samples of an individual.
\item An individual must have more than two samples for this representation.
}
}

Besides that the function also produces lines that connect mothers and
their offspring (\code{maternityLines}), fathers and their offspring
(\code{paternityLines}), and if \code{fullsibdata} parameter is specified,
full siblings (\code{FullsibLines}).
}
\description{
Creates georeferenced data for spatial
pedigree representation form the output of \code{\link[=plot_table]{plot_table()}} function.
}
\details{
The parameters \code{path}, \code{filename} and \code{out.format}, are used only when \code{output}
parameter is set to "gis", since they control which georeferenced files should
be created, where they will be saved and which common file name will they have.
}
\examples{
# Prepare the data for usage with ped_spatial() function.
# Get animal timespan data using the anim_timespan() function.
animal_ts <- anim_timespan(wolf_samples$AnimalRef,
  wolf_samples$Date,
  wolf_samples$SType,
  dead = c("Tissue")
)
# Add animal timespan to the sampledata
sampledata <- merge(wolf_samples, animal_ts, by.x = "AnimalRef", by.y = "ID", all.x = TRUE)
# Define the path to the pedigree data file.
path <- paste0(system.file("extdata", package = "wpeR"), "/wpeR_samplePed")
# Retrieve the pedigree data from the get_colony function.
ped_colony <- get_colony(path, sampledata, rm_obsolete_parents = TRUE, out = "FamAgg")
# Organize families and expand pedigree data using the org_fams function.
org_tables <- org_fams(ped_colony, sampledata, output = "both")
# Prepare data for plotting.
pt <- plot_table(plot_fams = 1,
  org_tables$fams,
  org_tables$ped,
  sampledata,
  deadSample = c("Tissue")
)

# Run the function
# Get files for spatial pedigree representation in list format.
ped_spatial(plottable = pt)


}
