% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_quantile_heatmap.r
\name{plot_quantile_heatmap}
\alias{plot_quantile_heatmap}
\title{Plot Wavelet Quantile Correlation Heatmap}
\usage{
plot_quantile_heatmap(
  df,
  label_levels = TRUE,
  palette = viridisLite::viridis(100)
)
}
\arguments{
\item{df}{Data frame with columns \code{Level}, \code{Quantile},
\code{Estimated_QC}, \code{CI_Lower}, and \code{CI_Upper}.}

\item{label_levels}{Logical; if \code{TRUE}, label the y-axis with level numbers.}

\item{palette}{Color palette vector for \code{col.regions}; default uses
\code{viridisLite::viridis(100)}.}
}
\value{
A \code{lattice} \code{levelplot} object (invisibly).
}
\description{
Create a heatmap of estimated quantile-wavelet correlations with white borders
for cells where the estimate lies outside its 95\% confidence interval.
}
\examples{
df <- data.frame(
  Level        = rep(1:2, each = 3),
  Quantile     = rep(c(0.1, 0.5, 0.9), times = 2),
  Estimated_QC = runif(6, -1, 1),
  CI_Lower     = rep(-0.5, 6),
  CI_Upper     = rep(0.5, 6)
)
# Use :: for namespace clarity, avoid library() calls
plot_quantile_heatmap(df, label_levels = TRUE, palette = viridisLite::viridis(100))

}
