% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmOrphans.R
\name{rmOrphans}
\alias{rmOrphans}
\title{Remove or Reassign Orphan Indexes}
\usage{
rmOrphans(
  ind,
  minN = 1,
  reassign = FALSE,
  side = "both",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{ind}{(integer) main input of (cluster-) indexes}

\item{minN}{(numeric, length=1) the min frequency to consider as orphans, if less than 1 it will be interpreted as ratio compared to length of \code{index}}

\item{reassign}{(logical) if \code{TRUE} orphan indexes will be replaced by neighbour class indexes (towrds the center)}

\item{side}{(character) may be 'both', 'b', 'upper', 'u', 'lower' or 'l' to decide if lower and/or upper end indexes should be treated.}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns an integer vector of adjusted indexes
}
\description{
This function allows detecting terminal orphans of a vector of (cluster-) indexes and removing (ie marking as \code{NA})
  or re-assigning them to the neighbour class towrds the center.
}
\details{
All input of \code{ind} is supposed to be interger values as (cluster-) indexes.
This function will look if the lowest and/or highest (cluster-) indexes appear at very low frequency so that they may be considered orphans. 
The argument \code{minN} assigns the threshold of when the frquency of terminal values may be considered as 'orphan',
either as absolute threshold or if less than 1 as ratio (0.1 => 10%tile of length of \code{ind}) .

The argument \code{side} may be 'both', 'b', 'upper', 'u', 'lower' or 'l', to decide if lower and/or upper end indexes should be treated.
}
\examples{
 x=c(3:1,3:4,4:6,5:3); rmOrphans(x)
rmOrphans(x, minN=0.2) 
## reassign orphans to neighbour center class
cbind(x,  x=x, def=rmOrphans(x, reassign=TRUE), 
  minN=rmOrphans(x, minN=0.2, reassign=TRUE) )
}
\seealso{
\code{\link[base]{table}}
}
