% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatIntTable.R
\name{combinatIntTable}
\alias{combinatIntTable}
\title{Planing For Making All Multiplicative Combinations}
\usage{
combinatIntTable(
  nMax,
  include0 = TRUE,
  asList = FALSE,
  callFrom = NULL,
  debug = FALSE,
  silent = TRUE
)
}
\arguments{
\item{nMax}{(positiveinteger) atomic compostion; could be max number of voting participants form different cities, eg Paris max 2 persons, Lyon max 1 person ...}

\item{include0}{(logical) include 0 occurances, ie provide al combinations starting from 0 or from 1 up to nMax}

\item{asList}{(logical) return result a}

\item{callFrom}{(character) allows easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}

\item{silent}{(logical) suppress messages}
}
\value{
This functions returns a list or array (as 2- or 3 dim) with possible number of occurances for each of the 3 elements in nMax. Read results vertical : out[[1]] or out[,,1] .. (multiplicative) table for 1st element of nMax; out[,,2] .. for 2nd
}
\description{
Provide all combinations for each of n elements of vector 'nMax' (positive integer, eg number of max multiplicative value).     
Results allow to see possible total compositons and must be read vertically.
}
\examples{
combinatIntTable(c(1,1,1,2), include0=TRUE, asList=FALSE, silent=TRUE)
nMa <- c(Paris=2,Lyon=1,Strasbourg=1)
combinatIntTable(nMa, include0=TRUE, asList=TRUE, silent=TRUE) 
}
\seealso{
\code{\link{combinateAllAndSum}}
}
