% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalIsoFragm.R
\name{.evalIsoFra}
\alias{.evalIsoFra}
\title{Evaluate Selected Lines Of PepTab}
\usage{
.evalIsoFra(
  x,
  prefFragPat = NULL,
  seqCol = "seq",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(matrix) main input, must contain cols specified as seqCol and "no","tailAA","precAA"}

\item{prefFragPat}{(matrix) specifies preferential fragmentation (which combination of AA to consider cols cTer,nTer,score), default made by \code{.prefFragPattern()}}

\item{seqCol}{(character) column names for the column containing the sequence to search for preferential cutting sites}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns line ID-numbers (pepTab[,"no"]) for those below median score (ie to remove from pepTab)
}
\description{
Evaluate selected lines of pepTab of SAME AA-length AND iso-mass for preferential cutting sites.
}
\examples{
peTab <- matrix(c("9","13","14","15", "LPVIAGHEAAG","PVIAGHEAAGI","EKKPFSI","KKPFSIE", 
  "P","L","E","E", "I","V","E","E"),nr=4,dimnames=list(NULL,c("no","seq","precAA","tailAA")))
.evalIsoFra(peTab)
}
\seealso{
\code{\link{makeFragments}}
}
