% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinateAllAndSum.R
\name{.parCombinateAllAndSum}
\alias{.parCombinateAllAndSum}
\title{Multiprocessor Version For Full Combinatorial And Cumulative Values}
\usage{
.parCombinateAllAndSum(
  uniqCo,
  massModV,
  nProc = NULL,
  firstOfRepeated = NULL,
  parRegDefault = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{uniqCo}{(matrix) number of modifications to be considered for each peptide}

\item{massModV}{(named numeric) mass modification values (names must match colnames of \code{uniqCo})}

\item{nProc}{(integer) number of processors to be used}

\item{firstOfRepeated}{(character)}

\item{parRegDefault}{(logical) - argument currently not in use}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This functions returns a list with single and combined mass-modifications (PTMs) for each peptide
}
\description{
This function combines all variants and sums them
}
\details{
This function requires the packages 'parallel' and 'BiocParallel' (from Bioconductor) 
Note : The function may work only on some Windows systems or may give warnings on Windows
}
\examples{
uniqCo <- matrix(c(1,1,1,0,1,1), nrow=2, dimnames=list(c("PTI","KPE"),c("d","p","h"))  )
massModV <- c(d=-18.01056, p=79.96633, h=-18.01056)
chPa <- c(requireNamespace("parallel", quietly=TRUE), 
  requireNamespace("BiocParallel", quietly=TRUE), "windows" \%in\% .Platform$OS.type)
## Note : the function may work only on some windows systems
if(all(chPa)) if(parallel::detectCores() >1) {
  .parCombinateAllAndSum(uniqCo, massModV, nProc=2)}
}
\seealso{
\code{\link[wrMisc]{convToNum}}
}
