% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMgfLike.R
\name{plotMgfLike}
\alias{plotMgfLike}
\title{Draw simplified (deconvoluted) spectrum of mgf type and highlight peaks with matches found to theoretical data}
\usage{
plotMgfLike(
  lst,
  basInp = NULL,
  backgrCol = NULL,
  replNames = c("by", "i"),
  lwd = 1,
  col = NULL,
  tit = NULL,
  xLim = NULL,
  yLab = NULL,
  linPlot = FALSE,
  listNa = c("identif", "overview", "obsMass"),
  useColN = c("obsMass", "logInt", "origNa", "mod", "modSpec", "fraNa", "orig",
    "nIdentif", "minMassDec", "maxMass"),
  cex = 1,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{(list) result of identificationi with element \code{$obsMass} (the column 'obsMass' should be m/z values, the column 'sc.logInt' intensity values) and $identif}

\item{basInp}{(numeric) alternative/custom entry of observaed masses}

\item{backgrCol}{(character) color of background}

\item{replNames}{(character)}

\item{lwd}{(numeric) line width}

\item{col}{(character) custom colors for different types of ions/modifications}

\item{tit}{(character) custom title}

\item{xLim}{(numeric length=2) custom x axis margins}

\item{yLab}{(character) custom y axis label}

\item{linPlot}{(logical) re-transform y-axis from log2 to linear scale}

\item{listNa}{(character) list-elements of 'lst' to use/extract}

\item{useColN}{(character) columns names tu use from input ie lst$identif & lst$overview}

\item{cex}{(numeric) expansion factor for x- and y-label}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a mgf-like figure
}
\description{
Draw simplified (deconvoluted) spectrum of mgf type and highlight matches found
}
\examples{
set.seed(2025)
}
\seealso{
\code{\link{makeFragments}}, \code{\link{identifVarModif}}, \code{\link{identifFixedModif}}, \code{\link{identifyPepFragments}}
}
