% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-company.R
\name{get_company}
\alias{get_company}
\title{Download Compustat company header data}
\usage{
get_company(
  wrds,
  region = c("na", "global"),
  columns = NULL,
  n = Inf,
  lazy = FALSE
)
}
\arguments{
\item{wrds}{A \code{DBIConnection} object returned by \code{\link[=wrds_connect]{wrds_connect()}}.}

\item{region}{One of \code{"na"} (North America, default) or \code{"global"}.}

\item{columns}{Character vector of columns to return. Defaults to key
identifiers and classification codes.}

\item{n}{Maximum number of rows to return. Defaults to \code{Inf} (all rows).
Use a smaller value (e.g., \code{n = 100}) to preview data before downloading
the full table.}

\item{lazy}{If \code{TRUE}, returns a lazy \code{tbl} instead of collecting.
Defaults to \code{FALSE}.}
}
\value{
A tibble with company header data. Default columns vary by region:

\strong{North America} (from \code{comp.company}):
\itemize{
\item \code{gvkey}, \code{conm}: Identifiers
\item \code{sic}, \code{naics}: Industry classifications (character)
\item \code{state}, \code{fic}, \code{loc}: Geographic information
}

\strong{Global} (from \code{comp.g_company}):
\itemize{
\item \code{gvkey}, \code{conm}: Identifiers
\item \code{sic}, \code{naics}: Industry classifications
\item \code{fic}, \code{loc}: Geographic information
}
}
\description{
Downloads company-level static data from Compustat including header SIC
codes, NAICS codes, state of incorporation, and other identifying
information.
}
\details{
The \code{sic} column contains the "header" SIC code, which is the company's
most recent SIC classification stored as a character. For historical SIC
codes that change over time, use \code{\link[=get_compustat]{get_compustat()}} with \code{fill_sic = TRUE},
which coalesces the historical \code{sich} (integer) with the header \code{sic}.
}
\examples{
\dontrun{
wrds <- wrds_connect()

# Get company header data
company <- get_company(wrds)

# Get global companies
g_company <- get_company(wrds, region = "global")

# Lazy query
get_company(wrds, lazy = TRUE) |>
  dplyr::filter(sic == "7370") |>
  dplyr::collect()

wrds_disconnect(wrds)
}
}
\seealso{
\code{\link[=get_compustat]{get_compustat()}} for fundamentals data with optional SIC filling
}
