% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link_ibes_crsp}
\alias{link_ibes_crsp}
\title{Get IBES-CRSP linking table}
\usage{
link_ibes_crsp(wrds, max_score = 5L, n = Inf, lazy = FALSE)
}
\arguments{
\item{wrds}{A \code{DBIConnection} object returned by \code{\link[=wrds_connect]{wrds_connect()}}.}

\item{max_score}{Maximum match quality score to include. Defaults to \code{5},
which excludes score 6 (the worst matches). Lower scores indicate

better matches:
\itemize{
\item \code{1}: Best match (CUSIP, ticker, and company name all match)
\item \code{2-5}: Progressively weaker matches
\item \code{6}: Worst match (excluded by default)
}}

\item{n}{Maximum number of rows to return. Defaults to \code{Inf} (all rows).
Use a smaller value (e.g., \code{n = 100}) to preview data before downloading
the full table.}

\item{lazy}{If \code{TRUE}, returns a lazy \code{tbl} instead of collecting.
Defaults to \code{FALSE}.}
}
\value{
A tibble with columns:
\describe{
\item{ticker}{IBES ticker}
\item{permno}{CRSP permanent security identifier}
\item{sdate}{Start date of the link}
\item{edate}{End date of the link}
\item{score}{Match quality score (1 = best, 6 = worst)}
}
}
\description{
Downloads the WRDS-provided linking table that maps IBES tickers to
CRSP PERMNOs with valid date ranges and match quality scores.
}
\details{
The linking table comes from \code{wrdsapps_link_crsp_ibes.ibcrsphist}.

To use the link, join on \code{ticker} and ensure your observation date falls
within the \code{sdate} to \code{edate} range.
}
\examples{
\dontrun{
wrds <- wrds_connect()
ibes_link <- link_ibes_crsp(wrds)

# Join with IBES data on ticker and date range
ibes_data |>
  dplyr::inner_join(ibes_link, by = dplyr::join_by(ticker)) |>
  dplyr::filter(date >= sdate, date <= edate)

wrds_disconnect(wrds)
}
}
\references{
WRDS IBES-CRSP Linking Table Documentation:
\url{https://wrds-www.wharton.upenn.edu/documents/796/IBES_CRSP_Linking_Table_by_WRDS.pdf}
}
\seealso{
\code{\link[=link_ccm]{link_ccm()}}
}
