% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bctrans.R
\name{bctrans}
\alias{bctrans}
\title{The one-parameter family of Box-Cox transformations}
\usage{
bctrans(y, lambda)
}
\arguments{
\item{y}{A numeric, positive values assumed}

\item{lambda}{The Box-Cox parameter}
}
\value{
\code{bctrans} gives \code{((y^lambda)-1)/lambda} for \code{lambda} not 0 or \code{ln(y)} for \code{lambda} equal to 0.
}
\description{
The one-parameter family of Box-Cox transformations
}
\details{
Internal function. No error checking done. It is assumed the entries of y are positive.
}
\references{
Box, GEP and Cox, DR (1964) An analysis of transformations (with discussion). Journal of the Royal Statistical Society B, 26, 211–252.

Venables, WN and Ripley, BD (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
\code{\link{cleandat}}, \code{browseVignettes("wsyn")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
